import pandas as pd   
import pickle

# Load the dataset
melbourne_housing = pd.read_csv("melb_data.csv")

# Calculate the maximum date in the dataset
max_date = pd.to_datetime(melbourne_housing['Date'], format='%d/%m/%Y').max().year
# Calculate the mean, median, and quartiles of property ages in Flemington
flemington_housing['Age'] = max_date - flemington_housing['YearBuilt']
property_ages = flemington_housing['Age']
 
# Calculate mean, median, first quartile, and third quartile
mean_age = property_ages.mean()
median_age = property_ages.median()
first_quartile = property_ages.quantile(0.25)
third_quartile = property_ages.quantile(0.75)
 
# Print the calculated values
print(f"Mean property age: {mean_age:.2f} years")
pickle.dump(mean_age,open("./ref_result/mean_age.pkl","wb"))

print(f"Median property age: {median_age:.2f} years")
pickle.dump(median_age,open("./ref_result/median_age.pkl","wb"))

print(f"First quartile: {first_quartile:.2f} years")
pickle.dump(first_quartile,open("./ref_result/first_quartile.pkl","wb"))

print(f"Third quartile: {third_quartile:.2f} years")
pickle.dump(third_quartile,open("./ref_result/third_quartile.pkl","wb"))
 
# Identify historical buildings that could be renovated for sustainability
# Calculate the threshold year for renovations
threshold_year = max_date - 30
 
# Identify buildings that could be renovated for sustainability
buildings_to_renovate = flemington_housing[flemington_housing['YearBuilt'] <= threshold_year]
print("\nBuildings that could be renovated for sustainability:")
print(buildings_to_renovate[['Suburb', 'Address', 'YearBuilt']])
pickle.dump(buildings_to_renovate,open("./ref_result/buildings_to_renovate.pkl","wb"))
